//-----------------------------------------------------------------------------
// VST Plug-Ins SDK
// VSTGUI: Graphical User Interface Framework for VST plugins
//
// Version 4.2
//
//-----------------------------------------------------------------------------
// VSTGUI LICENSE
// (c) 2013, Steinberg Media Technologies, All Rights Reserved
//-----------------------------------------------------------------------------
// Redistribution and use in source and binary forms, with or without modification,
// are permitted provided that the following conditions are met:
// 
//   * Redistributions of source code must retain the above copyright notice, 
//     this list of conditions and the following disclaimer.
//   * Redistributions in binary form must reproduce the above copyright notice,
//     this list of conditions and the following disclaimer in the documentation 
//     and/or other materials provided with the distribution.
//   * Neither the name of the Steinberg Media Technologies nor the names of its
//     contributors may be used to endorse or promote products derived from this 
//     software without specific prior written permission.
// 
// THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND
// ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED 
// WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. 
// IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, 
// INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, 
// BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, 
// DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF 
// LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE 
// OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE  OF THIS SOFTWARE, EVEN IF ADVISED
// OF THE POSSIBILITY OF SUCH DAMAGE.
//-----------------------------------------------------------------------------

#ifndef __vstgui__
#define __vstgui__

#include "lib/vstguibase.h"
#include "lib/cbitmap.h"
#include "lib/cbitmapfilter.h"
#include "lib/ccolor.h"
#include "lib/cdatabrowser.h"
#include "lib/cdrawcontext.h"
#include "lib/cdropsource.h"
#include "lib/cfileselector.h"
#include "lib/cfont.h"
#include "lib/cframe.h"
#include "lib/cgradientview.h"
#include "lib/cgraphicspath.h"
#include "lib/clayeredviewcontainer.h"
#include "lib/coffscreencontext.h"
#include "lib/copenglview.h"
#include "lib/cpoint.h"
#include "lib/crect.h"
#include "lib/crowcolumnview.h"
#include "lib/cscrollview.h"
#include "lib/cshadowviewcontainer.h"
#include "lib/csplitview.h"
#include "lib/cstring.h"
#include "lib/ctabview.h"
#include "lib/ctooltipsupport.h"
#include "lib/cview.h"
#include "lib/cviewcontainer.h"
#include "lib/cvstguitimer.h"
#include "lib/vstguidebug.h"

#include "lib/controls/cautoanimation.h"
#include "lib/controls/cbuttons.h"
#include "lib/controls/ccolorchooser.h"
#include "lib/controls/ccontrol.h"
#include "lib/controls/cfontchooser.h"
#include "lib/controls/cknob.h"
#include "lib/controls/cmoviebitmap.h"
#include "lib/controls/cmoviebutton.h"
#include "lib/controls/coptionmenu.h"
#include "lib/controls/cparamdisplay.h"
#include "lib/controls/cslider.h"
#include "lib/controls/cspecialdigit.h"
#include "lib/controls/csplashscreen.h"
#include "lib/controls/cswitch.h"
#include "lib/controls/ctextedit.h"
#include "lib/controls/ctextlabel.h"
#include "lib/controls/cvumeter.h"
#include "lib/controls/cxypad.h"

#include "lib/animation/animations.h"
#include "lib/animation/animator.h"
#include "lib/animation/timingfunctions.h"

using namespace VSTGUI;

#endif	// __vstgui__
